/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.jobs;

import jtbcore.jobs.TaskUpdate;
import jtbcore.jobs.interfaces.RunnableExceptionHandler;
import jtbcore.jobs.interfaces.TaskUpdateListener;

public abstract class TaskBase {
    protected String taskName = "Default name";
    protected TaskUpdateListener taskUpdateListener = null;
    protected RunnableExceptionHandler exceptionHandler = null;

    public TaskBase(TaskUpdateListener taskUpdateListener, RunnableExceptionHandler exceptionHandler) {
        this.taskUpdateListener = taskUpdateListener;
        this.exceptionHandler = exceptionHandler;
    }

    public Integer getId() {
        return null;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskUpdateListener(TaskUpdateListener listener) {
        this.taskUpdateListener = listener;
    }

    public TaskUpdateListener getTaskUpdateListener() {
        return this.taskUpdateListener;
    }

    public RunnableExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(RunnableExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public boolean handleException(Exception ex) {
        if (this.exceptionHandler == null) {
            return false;
        }
        this.exceptionHandler.handleException(ex);
        return true;
    }

    public void update(String message, TaskUpdate.MessageType messageType, Integer counter, Double progress) {
        if (this.taskUpdateListener == null) {
            return;
        }
        TaskUpdate u = new TaskUpdate();
        u.task = this;
        u.message = message;
        u.messageType = messageType;
        u.counter = counter;
        u.progress = progress;
        this.taskUpdateListener.taskUpdateEvent(u);
    }

    public abstract void execute() throws Exception;
}

